package jamezo97.clonecraft.network;

import jamezo97.clonecraft.entity.clone.EntityClone;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.EnumChatFormatting;
import cpw.mods.fml.relauncher.Side;

public class Handler11ChangeOwner extends Handler{
	
	@Value(id = 0)
	int entityId;

	public Handler11ChangeOwner(int entityId) {
		this.entityId = entityId;
	}

	public Handler11ChangeOwner() {

	}

	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
		if(side == Side.SERVER){
			EntityClone clone = getCloneOnServer(entityId, player.worldObj);
			if(clone != null){
				if(clone.canUseThisEntity(player.username)){
					if(!MinecraftServer.getServer().isServerInOnlineMode()){
						if(clone.owner != null && clone.owner.equals(player.username)){
							player.sendChatToPlayer(ChatMessageComponent.createFromText("You already own this clone").setColor(EnumChatFormatting.GOLD));
						}else{
							player.sendChatToPlayer(ChatMessageComponent.createFromText("You now own this clone").setColor(EnumChatFormatting.GOLD));
							clone.setOwner(player.username);
							clone.onValueChanged(EntityClone.ID_OWNER, false);
						}
					}else{
						player.sendChatToPlayer(ChatMessageComponent.createFromText("You can't do that..").setColor(EnumChatFormatting.RED));
					}
				}
			}
		}
	}



}
